<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Ims</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Providers</h1>
				<xsl:call-template name="providers"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="providers">
	<table>
		<tr>
			<th>id</th>
			<th>name</th>
			<th>fullname</th>
			<th>category</th>
			<th>signUpUrl</th>
			<th>account</th>	
		</tr>
		
		<xsl:for-each select="provider">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@name"/></td>
				<td><xsl:value-of select="@fullname"/></td>
				<td><xsl:value-of select="category"/></td>
				<td><xsl:value-of select="signUpUrl"/></td>
				<td>
					<xsl:if test="count( account ) > 0">
						<xsl:call-template name="accounts"/>
					</xsl:if>
				</td>
				
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="accounts">
	<table>
		<tr>
			<th>id</th>
			<th>name</th>
			<th>username</th>
			<th>password</th>
			<th>active</th>
			<th>locked</th>
			<th>keepSignedIn</th>
			<th>contact</th>
			<th>avatar</th>
		</tr>
		
		<xsl:for-each select="account">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@name"/></td>
				<td><xsl:value-of select="@username"/></td>
				<td><xsl:value-of select="@password"/></td>
				<td><xsl:value-of select="@active"/></td>
				<td><xsl:value-of select="@locked"/></td>
				<td><xsl:value-of select="@keepSignedIn"/></td>
				<td>
					<xsl:if test="count( contact ) > 0">
						<xsl:call-template name="contacts"/>
					</xsl:if>
				</td>
				<td>
					<xsl:if test="count( avatar ) > 0">
						<xsl:call-template name="avatars"/>
					</xsl:if>
				</td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="contacts">
	<table>
		<tr>
			<th>id</th>
			<th>username</th>
			<th>nickname</th>
			<th>type</th>
			<th>subscriptionStatus</th>
			<th>subscriptionType</th>
			<th>rejected</th>
			<th>blocked</th>
			<th>message</th>
		</tr>
		
		<xsl:for-each select="contact">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@username"/></td>
				<td><xsl:value-of select="@nickname"/></td>
				<td><xsl:value-of select="@type"/></td>
				<td><xsl:value-of select="@subscriptionStatus"/></td>
				<td><xsl:value-of select="@subscriptionType"/></td>
				<td><xsl:value-of select="@rejected"/></td>
				<td><xsl:value-of select="@blocked"/></td>
				<td>
					<xsl:if test="count( message ) > 0">
						<xsl:call-template name="messages"/>
					</xsl:if>
				</td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="avatars">
	<table>
		<tr>
			<th>id</th>
			<th>hash</th>
			<th>localpath</th>
		</tr>
		
		<xsl:for-each select="avatar">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="id"/></td>
				<td><xsl:value-of select="hash"/></td>
				<td><xsl:value-of select="localpath"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="messages">
	<table>
		<tr>
			<th>id</th>
			<th>date</th>
			<th>errorCode</th>
			<th>type</th>
			<th>body</th>
			<th>errorMessage</th>
		</tr>
			
		<xsl:for-each select="message">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@date"/></td>
				<td><xsl:value-of select="@errorCode"/></td>
				<td><xsl:value-of select="@type"/></td>
				<td><xsl:value-of select="body"/></td>
				<td><xsl:value-of select="errorMessage"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

